<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\Ledger;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LedgerController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = Ledger::class;
    }

    public function index()
    {
        abort_if(Gate::denies('ledger_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger.index');
    }

    public function create()
    {
        abort_if(Gate::denies('ledger_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger.create');
    }

    public function edit(Ledger $ledger)
    {
        abort_if(Gate::denies('ledger_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger.edit', compact('ledger'));
    }

    public function show(Ledger $ledger)
    {
        abort_if(Gate::denies('ledger_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $ledger->load('ledgerGroup');

        return view('admin.ledger.show', compact('ledger'));
    }
}
