<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\JobDesignation;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class JobDesignationController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('job_designation_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.job-designation.index');
    }

    public function create()
    {
        abort_if(Gate::denies('job_designation_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.job-designation.create');
    }

    public function edit(JobDesignation $jobDesignation)
    {
        abort_if(Gate::denies('job_designation_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.job-designation.edit', compact('jobDesignation'));
    }

    public function show(JobDesignation $jobDesignation)
    {
        abort_if(Gate::denies('job_designation_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.job-designation.show', compact('jobDesignation'));
    }
}
