<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\EmployeeInfo;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EmployeeInfoController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = EmployeeInfo::class;
    }

    public function index()
    {
        abort_if(Gate::denies('employee_info_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-info.index');
    }

    public function create()
    {
        abort_if(Gate::denies('employee_info_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-info.create');
    }

    public function edit(EmployeeInfo $employeeInfo)
    {
        abort_if(Gate::denies('employee_info_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-info.edit', compact('employeeInfo'));
    }

    public function show(EmployeeInfo $employeeInfo)
    {
        abort_if(Gate::denies('employee_info_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeInfo->load('user', 'jobDesgination');

        return view('admin.employee-info.show', compact('employeeInfo'));
    }
}
