<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmployeeEducationalInfo;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EmployeeEducationalInfoController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('employee_educational_info_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-educational-info.index');
    }

    public function create()
    {
        abort_if(Gate::denies('employee_educational_info_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-educational-info.create');
    }

    public function edit(EmployeeEducationalInfo $employeeEducationalInfo)
    {
        abort_if(Gate::denies('employee_educational_info_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-educational-info.edit', compact('employeeEducationalInfo'));
    }

    public function show(EmployeeEducationalInfo $employeeEducationalInfo)
    {
        abort_if(Gate::denies('employee_educational_info_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeEducationalInfo->load('employeeInfo');

        return view('admin.employee-educational-info.show', compact('employeeEducationalInfo'));
    }
}
