<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Livewire\Prints\Admin\Reports\MonthlyAttendanceExportReport;
use App\Models\EmployeeAttendanceLog;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Barryvdh\DomPDF\Facade\Pdf as BarryPDF;
use Livewire\Livewire;

class EmployeeAttendanceLogController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('employee_attendance_log_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-attendance-log.index');
    }

    public function create()
    {
        abort_if(Gate::denies('employee_attendance_log_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-attendance-log.create');
    }

    public function edit(EmployeeAttendanceLog $employeeAttendanceLog)
    {
        abort_if(Gate::denies('employee_attendance_log_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-attendance-log.edit', compact('employeeAttendanceLog'));
    }

    public function show(EmployeeAttendanceLog $employeeAttendanceLog)
    {
        abort_if(Gate::denies('employee_attendance_log_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeAttendanceLog->load('user');

        return view('admin.employee-attendance-log.show', compact('employeeAttendanceLog'));
    }


    public function storeMedia(Request $request)
    {
        // return ($request->input());
        abort_if(Gate::none(['employee_attendance_log_create', 'employee_attendance_log_edit']), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->has('size')) {
            $this->validate($request, [
                'file' => 'max:' . $request->input('size') * 1024,
            ]);
        }
        if (request()->has('max_width') || request()->has('max_height')) {
            $this->validate(request(), [
                'file' => sprintf(
                    'image|dimensions:max_width=%s,max_height=%s',
                    request()->input('max_width', 100000),
                    request()->input('max_height', 100000)
                ),
            ]);
        }

        $model                     = new EmployeeAttendanceLog();
        $model->id                 = $request->input('model_id', 0);
        $model->exists             = true;
        $media                     = $model->addMediaFromRequest('file')->toMediaCollection($request->input('collection_name'));
        $media->wasRecentlyCreated = true;

        return response()->json(compact('media'), Response::HTTP_CREATED);
    }

    public function monthlyReport(Request $request)
    {
        $user = $request->user();
        abort_unless($user && $user->isAdmin(), Response::HTTP_FORBIDDEN, '403 Forbidden');


        return view('admin.employee-attendance-log.monthly-report'/* , compact('employeeAttendanceLog') */);
    }

    public function monthlyReportExport(Request $request, MonthlyAttendanceExportReport $monthlyAttendanceExportReport)
    {
        $user = $request->user();
        abort_unless($user && $user->isAdmin(), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $state =  $request->get('s');
        // $month = $request->get('s.month', date('m'));
        // $year = $request->get('s.year', date('Y'));
        // $month = $request->get('s[month]', date('m'));
        // $year = $request->get('s[year]', date('Y'));
        ['year' => $year, 'month' => $month] = $state;
        $export = $request->get('e', 'html');

        // $monthlyAttendanceExportReport->setMonth($month);
        // $monthlyAttendanceExportReport->setYear($year);
        $monthlyAttendanceExportReport->fill([
            'state.month' => $month,
            'state.year' => $year,
            // 'state[month]' => $month,
            // 'state[year]' => $year,
        ]);
        // ds([
        //     'lw' => $monthlyAttendanceExportReport,
        //     'y' => $year,
        //     'm' => $month,
        // ]);
        // dd();
        $data = $monthlyAttendanceExportReport->getDataForExternal($year, $month);

        // ds([
        //     'data' => $data,
        // ]);
        // $monthlyAttendanceExportReport->mount();
        // $html =  $monthlyAttendanceExportReport
        //     ->render()
        //     // ->renderToView()
        //     // ->output()
        //     //
        // ;

        if ($export == 'pdf') {
            $pdf = BarryPDF::loadView('prints.monthly-attendance-export-report-v1', $data)->setOptions([
                'defaultFont' => 'sans-serif',
                'isHtml5ParserEnabled' => true,
                "enable_php" => true,
            ])
                ->setPaper('a3', 'landscape')
                // ->setPaper('a4', 'landscape')
                //
            ;
            return $pdf->stream();
        } else {
            return view('prints.monthly-attendance-export-report-v1', $data);
        }
    }
}
