<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\ClientGroup;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ClientGroupController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = ClientGroup::class;
    }

    public function index()
    {
        abort_if(Gate::denies('client_group_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client-group.index');
    }

    public function create()
    {
        abort_if(Gate::denies('client_group_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client-group.create');
    }

    public function edit(ClientGroup $clientGroup)
    {
        abort_if(Gate::denies('client_group_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client-group.edit', compact('clientGroup'));
    }

    public function show(ClientGroup $clientGroup)
    {
        abort_if(Gate::denies('client_group_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $clientGroup->load('zone', 'state', 'circle');

        return view('admin.client-group.show', compact('clientGroup'));
    }
}
