<?php

namespace App\Exports;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Schema;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ModelExport implements FromCollection, WithHeadings, WithMapping
{
    use Exportable;

    private Model $model;

    public function __construct(Model $model)
    {
        $this->model = $model;
    }

    public function collection(): Collection
    {
        $headings = $this->headings();
        $headingKeys = array_keys($headings);
        $collection = $this->model->select($headingKeys)->get();
        return $collection;
    }

    public function headings(): array
    {
        $fillableColumns = $this->model->getFillable();
        $hiddenColumns = $this->model->getHidden();
        $headingRows = array_diff($fillableColumns, $hiddenColumns);
        $headingRowsAssoc = collect($headingRows)->mapWithKeys(function ($columnName) {
            return  [$columnName => Str::title($columnName)];
        })->toArray();

        return $headingRowsAssoc;
    }

    public function map($row): array
    {
        $rowAssoc = collect($row->getAttributes())->mapWithKeys(function ($value, $key) {
            return  [$key => $value];
        })->toArray();
        return $rowAssoc;
    }
}
